﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;
using ext = Ext.Net;

public partial class ucLogin : System.Web.UI.UserControl
{
    //basemaster property
    public BaseMaster BaseMstr { get; set; }
    public string strPageAfterLogin = "portal_start.aspx";

    /// <summary>
    /// Page Loads
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {}

    /// <summary>
    /// US:6969,6970 attempts to login using the given credentials
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLogin_Click(object sender, ext.DirectEventArgs e)
    {
        CSec sec = new CSec();
        CDataUtils utils = new CDataUtils();

        string strUsername = txtUsername.Text;
        string strPassword = txtPassword.Text;
        long lLoginStatus;

        lLoginStatus = sec.Login(BaseMstr, strUsername, strPassword);
        
        //everything's ok to continue to the portal
        if (lLoginStatus == 0) {
            
            //set a session variable with the login time
            Session["SESSION_INITIATED"] = DateTime.Now;
            GetPatientID();
            ext.X.Mask.Show(new ext.MaskConfig { Msg = "Please wait" });
            Response.Redirect(strPageAfterLogin);
        }

        //patient must change password
        else if (lLoginStatus == 4)
        {
            Session["USER_NAME"] = strUsername.Trim();
            ext.X.Mask.Show(new ext.MaskConfig { Msg = "Please wait" });
            Response.Redirect("change_password.aspx");
        }

        else {
            BaseMstr.ShowSystemFeedback(BaseMstr.StatusComment, "Login Error");
        }
    }

    /// <summary>
    /// Get the PatientID of the logged in patient
    /// </summary>
    protected void GetPatientID()
    {
        CPatient pat = new CPatient(BaseMstr);
        CDataUtils utils = new CDataUtils();
        DataSet dsPat = pat.GetPatientIDRS(BaseMstr.FXUserID);
        string strPatientID = utils.GetDSStringValue(dsPat, "PATIENT_ID");
        BaseMstr.SelectedPatientID = strPatientID;
    }

    /// <summary>
    /// US:6971 redirects the patient to the reset password page
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ResetPasswd_DirectClick(object sender, ext.DirectEventArgs e)
    {
        Response.Redirect("reset_password.aspx");
    }
}
